/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.configbuilder.ConfigEntry;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;

public abstract class ServerConfig {
    public ConfigEntry<Integer> voiceChatPort;
    public ConfigEntry<String> voiceChatBindAddress;
    public ConfigEntry<Double> voiceChatDistance;
    public ConfigEntry<Double> crouchDistanceMultiplier;
    public ConfigEntry<Double> whisperDistanceMultiplier;
    public ConfigEntry<Codec> voiceChatCodec;
    public ConfigEntry<Integer> voiceChatMtuSize;
    public ConfigEntry<Integer> keepAlive;
    public ConfigEntry<Boolean> groupsEnabled;
    public ConfigEntry<Boolean> openGroups;
    public ConfigEntry<String> voiceHost;
    public ConfigEntry<Boolean> allowRecording;
    public ConfigEntry<Boolean> spectatorInteraction;
    public ConfigEntry<Boolean> spectatorPlayerPossession;
    public ConfigEntry<Boolean> forceVoiceChat;
    public ConfigEntry<Integer> loginTimeout;
    public ConfigEntry<Double> broadcastRange;

    public ServerConfig(ConfigBuilder builder) {
        builder.header(String.format("%s server config v%s", CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()));
        this.voiceChatPort = builder.integerEntry("port", 24454, -1, 65535, "The port of the voice chat server", "Setting this to \"-1\" sets the port to the Minecraft servers port");
        this.voiceChatBindAddress = builder.stringEntry("bind_address", "", "The IP address to bind the voice chat server on", "Leave empty to bind to an IP address chosen by the kernel");
        this.voiceChatDistance = builder.doubleEntry("max_voice_distance", 48.0, 1.0, 1000000.0, "The distance to where the voice can be heard");
        this.crouchDistanceMultiplier = builder.doubleEntry("crouch_distance_multiplier", 1.0, 0.01, 1.0, "The multiplier the voice distance will be reduced by when sneaking");
        this.whisperDistanceMultiplier = builder.doubleEntry("whisper_distance_multiplier", 0.5, 0.01, 1.0, "The multiplier the voice distance will be reduced by when whispering");
        this.voiceChatCodec = builder.enumEntry("codec", Codec.VOIP, "The opus codec");
        this.voiceChatMtuSize = builder.integerEntry("mtu_size", 1024, 256, 10000, "The maximum size in bytes in a voice packet", "Set this to a lower value if your voice packets don't arrive");
        this.keepAlive = builder.integerEntry("keep_alive", 1000, 1000, Integer.MAX_VALUE, "The frequency in which keep alive packets are sent", "Setting this to a higher value may result in timeouts");
        this.groupsEnabled = builder.booleanEntry("enable_groups", true, "If group chats are allowed");
        this.openGroups = builder.booleanEntry("open_groups", false, "If players in group chats can be heard locally");
        this.voiceHost = builder.stringEntry("voice_host", "", "The host name that clients should use to connect to the voice chat", "Don't change this value if you don't know what you are doing");
        this.allowRecording = builder.booleanEntry("allow_recording", true, "If players are allowed to record the voice chat");
        this.spectatorInteraction = builder.booleanEntry("spectator_interaction", false, "If spectators are allowed to talk to other players");
        this.spectatorPlayerPossession = builder.booleanEntry("spectator_player_possession", false, "If spectators can talk to players they are spectating");
        this.forceVoiceChat = builder.booleanEntry("force_voice_chat", false, "If players without the mod should get kicked from the server");
        this.loginTimeout = builder.integerEntry("login_timeout", 10000, 100, Integer.MAX_VALUE, "The amount of milliseconds, the server should wait to check if the player has the mod installed", "Only active when force_voice_chat is set to true");
        this.broadcastRange = builder.doubleEntry("broadcast_range", -1.0, -1.0, Double.MAX_VALUE, "The range where the voice chat should broadcast audio to", "A value <0 means 'max_voice_distance'");
    }

    public static enum Codec {
        VOIP(2048),
        AUDIO(2049),
        RESTRICTED_LOWDELAY(2051);

        private final int value;

        private Codec(int value) {
            this.value = value;
        }

        public int getOpusValue() {
            return this.value;
        }
    }
}

